@foreach ($variants as $variant)
    @php
        $types = apply_filters('modify_gallery_data', ['video', 'text_to_video', 'ai_persona', 'ai_avatar'])
    @endphp
    <div class="swiper-slide rounded-lg w-full h-full relative" id="{{ $variant->id }}">
        @if (in_array($variant->type, $types))
            <div class="video-container xl:!w-[512px] xl:!h-[512px] !h-[354px]">
                <video class="object-cover rounded-lg myVideos xl:!w-[512px] xl:!h-[512px] !h-[354px]">
                    <source src="{{ $variant->videoUrl() }}" type="video/mp4">
                </video>
                <div class="custom-controls">
                    <button class="custom-play-pause playPauseBtn md:p-5 p-2">
                        <svg class="playIcon w-[30px] h-[30px]" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40"
                            fill="none">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M9.44906 7.93287C9.49374 7.55428 9.62621 7.19135 9.83592 6.873C10.0456 6.55464 10.3268 6.28965 10.657 6.09914C10.9872 5.90863 11.3573 5.79786 11.7379 5.77564C12.1184 5.75343 12.4989 5.8204 12.8491 5.9712C14.6191 6.72787 18.5857 8.5262 23.6191 11.4312C28.6541 14.3379 32.1957 16.8762 33.7341 18.0279C35.0474 19.0129 35.0507 20.9662 33.7357 21.9545C32.2124 23.0995 28.7141 25.6045 23.6191 28.5479C18.5191 31.4912 14.5991 33.2679 12.8457 34.0145C11.3357 34.6595 9.64573 33.6812 9.44906 32.0529C9.21906 30.1495 8.78906 25.8279 8.78906 19.9912C8.78906 14.1579 9.2174 9.83787 9.44906 7.93287Z"
                                fill="white" />
                        </svg>
                        <svg class="pauseIcon w-[30px] h-[30px] hidden"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40" fill="none">
                            <path
                                d="M13.334 4.16699H10.0007C7.69946 4.16699 5.83398 6.03247 5.83398 8.33366V31.667C5.83398 33.9682 7.69946 35.8337 10.0007 35.8337H13.334C15.6352 35.8337 17.5007 33.9682 17.5007 31.667V8.33366C17.5007 6.03247 15.6352 4.16699 13.334 4.16699Z"
                                fill="white" />
                            <path
                                d="M30 4.16699H26.6667C24.3655 4.16699 22.5 6.03247 22.5 8.33366V31.667C22.5 33.9682 24.3655 35.8337 26.6667 35.8337H30C32.3012 35.8337 34.1667 33.9682 34.1667 31.667V8.33366C34.1667 6.03247 32.3012 4.16699 30 4.16699Z"
                                fill="white" />
                        </svg>
                    </button>
                </div>
                <div class="progress-container">
                    <div class="progress-video-bar"></div>
                </div>
            </div>
        @else
            <img class="rounded-lg w-full h-full object-cover main-image" src="{{ $variant->imageUrl(['thumbnill' => true, 'size' => 'medium']) }}" alt="{{ __('Variant') }}" />
        @endif
        
        <div class="absolute top-3 right-3 z-10 flex gap-2">
            <a href="{{ in_array($variant->type, $types) ? $variant->videoUrl() : $variant->imageUrl() }}" download="{{ $variant->title }}" class="file-need-download relative md:w-[34px] md:h-[34px] w-7 h-7 flex items-center m-auto justify-center rounded-lg delete-image-bg border border-color-47">
                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M9 2.25C9.41421 2.25 9.75 2.58579 9.75 3V10.1893L12.2197 7.71967C12.5126 7.42678 12.9874 7.42678 13.2803 7.71967C13.5732 8.01256 13.5732 8.48744 13.2803 8.78033L9.53033 12.5303C9.23744 12.8232 8.76256 12.8232 8.46967 12.5303L4.71967 8.78033C4.42678 8.48744 4.42678 8.01256 4.71967 7.71967C5.01256 7.42678 5.48744 7.42678 5.78033 7.71967L8.25 10.1893V3C8.25 2.58579 8.58579 2.25 9 2.25ZM3 12C3.41421 12 3.75 12.3358 3.75 12.75V14.25C3.75 14.4489 3.82902 14.6397 3.96967 14.7803C4.11032 14.921 4.30109 15 4.5 15H13.5C13.6989 15 13.8897 14.921 14.0303 14.7803C14.171 14.6397 14.25 14.4489 14.25 14.25V12.75C14.25 12.3358 14.5858 12 15 12C15.4142 12 15.75 12.3358 15.75 12.75V14.25C15.75 14.8467 15.5129 15.419 15.091 15.841C14.669 16.2629 14.0967 16.5 13.5 16.5H4.5C3.90326 16.5 3.33097 16.2629 2.90901 15.841C2.48705 15.419 2.25 14.8467 2.25 14.25V12.75C2.25 12.3358 2.58579 12 3 12Z" fill="#F3F3F3"/>
                </svg>   
            </a>
            <a href="javascript: void(0)" class="favorite-modal favorite-modal-image-{{$variant->id }}" onclick="modalImageToggle(this)" data-image-id="{{ $variant->id }}" data-is-favorite="{{ in_array($variant->id, $userFavoriteImages) ? 'true' : 'false' }}">
                @if ( in_array($variant->id, $userFavoriteImages) )
                    <div class="relative md:w-[34px] md:h-[34px] w-7 h-7 flex items-center m-auto justify-center rounded-lg bg-white wishlist-border">
                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9 4.5L6.5 3L3.5 4L2.5 6V8.5L9 15L9.5 14.5L12 11.5L14.5 9.5L15.5 7.5L14.5 4.5L11.5 3L9 4.5Z" fill="#E22861"/>
                            <path d="M9.00077 3.39692C9.85769 2.62982 10.9759 2.22007 12.1256 2.25187C13.2752 2.28368 14.3691 2.75462 15.1823 3.56792C15.9948 4.38031 16.4658 5.47273 16.4987 6.62123C16.5316 7.76974 16.1239 8.88733 15.3593 9.74492L8.99927 16.1139L2.64077 9.74492C1.87521 8.88689 1.46717 7.76834 1.50042 6.61891C1.53367 5.46948 2.00569 4.37638 2.81956 3.56404C3.63344 2.7517 4.72742 2.28175 5.87691 2.25067C7.02641 2.21959 8.14419 2.62974 9.00077 3.39692ZM14.1203 4.62767C13.5785 4.08626 12.85 3.77273 12.0843 3.75139C11.3187 3.73005 10.5739 4.00253 10.0028 4.51292L9.00152 5.41142L7.99952 4.51367C7.43077 4.00509 6.68961 3.73232 5.92687 3.75086C5.16412 3.7694 4.43709 4.07787 3.89373 4.61349C3.35037 5.14911 3.03151 5.87163 3.00202 6.63404C2.97254 7.39644 3.23465 8.14143 3.73502 8.71742L9.00002 13.9907L14.265 8.71817C14.7633 8.14472 15.0254 7.4036 14.9986 6.6444C14.9717 5.8852 14.6578 5.16446 14.1203 4.62767Z" fill="#E22861"/>
                        </svg> 
                    </div>
                @else
                    <div class="relative md:w-[34px] md:h-[34px] w-7 h-7 flex items-center m-auto justify-center rounded-lg delete-image-bg border border-color-47">
                        <svg width="16" height="15" viewBox="0 0 16 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M8.00077 1.39692C8.85769 0.629819 9.97588 0.220071 11.1256 0.251875C12.2752 0.283678 13.3691 0.754618 14.1823 1.56792C14.9948 2.38031 15.4658 3.47273 15.4987 4.62123C15.5316 5.76974 15.1239 6.88733 14.3593 7.74492L7.99927 14.1139L1.64077 7.74492C0.875208 6.88689 0.467169 5.76834 0.500419 4.61891C0.533668 3.46948 1.00568 2.37638 1.81956 1.56404C2.63344 0.751699 3.72742 0.281748 4.87691 0.250669C6.02641 0.21959 7.14418 0.629741 8.00077 1.39692ZM13.1203 2.62767C12.5785 2.08626 11.85 1.77273 11.0843 1.75139C10.3187 1.73005 9.57389 2.00253 9.00277 2.51292L8.00152 3.41142L6.99952 2.51367C6.43077 2.00509 5.68961 1.73232 4.92687 1.75086C4.16412 1.7694 3.43709 2.07787 2.89373 2.61349C2.35037 3.14911 2.03151 3.87163 2.00202 4.63404C1.97254 5.39644 2.23465 6.14143 2.73502 6.71742L8.00002 11.9907L13.265 6.71817C13.7633 6.14472 14.0254 5.4036 13.9986 4.6444C13.9717 3.8852 13.6578 3.16446 13.1203 2.62767Z" fill="white"/>
                        </svg>
                    </div>
                @endif
            </a>
        </div>
    </div>
@endforeach
